function [uu]=fdtd_cuerda( xa, xb, u0, du0, ua, ub, c, tmax, dt, nx)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% funcion [uu]=fdtd( x, u0, du0, ua, ub, c, tmax, dt)                     %
%                                                                         %
% Resuelve la ecuacion en derivadas parciales de una cuerda tensa         %
% vibrante.                                                               %
%                                                                         %
% ENTRADA                                                                 %
%    xa, xb  limites del dominio espacial                                 %
%        u0  condicion inicial para la variable dependiente               %
%       du0  condicion inical para la derivada con respecto al tiempo     %
%            de la variable dependiente                                   %
%     ua,ub  valores de la variable dependiente en los contornos          %
%         c  velocidad de propagacion de la perturbacion                  %
%      tmax  valor temporal hasta el que se desea integrar                %
%        dt  paso temporal                                                %
%        nx  numero de puntos de la malla en x                            %
%                                                                         %
% Supone VECTORES COLUMNA.                                                %
%                                                                         %
%                                                                         %
% SALIDA                                                                  %
%       uu   matriz en la cual cada columna contiene los valores de u     %
%            en un instante                                               %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Reservamos memoria para los arrays
% El array uu podría ser bastante grande

x = linspace( xa, xb, nx);
nt = ceil( tmax/dt );
uu = zeros( nx, nt);

% asignamos los valores iniciales y de contorno
uu( :, 1) = u0;
uu( 1, :) = ua;
uu(nx, :) = ub;

dx = x(2) - x(1);
epsilon = (dt*c/dx)^2;
fprintf('\n (dt*c/dx)^2 = %e\n',epsilon);

uu( 2:nx-1 , 2) = 0.5*epsilon*( uu( 3:nx, 1 ) + uu( 1:nx-2, 1) ) + ...
                 (1.0 - epsilon)*uu( 2:nx-1, 1) + dt * du0(2:nx-1);
% for ii=2:nx-1
%     uu( ii,2) = 0.5*epsilon*( uu(ii+1,1) + uu(ii-1,1) ) + ...
%                 (1.0-epsilon)*uu(ii,1) + dt*du0(ii);
% end
              
for jj = 2:nt-1
    uu( 2:nx-1 , jj+1) = ...
        epsilon*( uu( 3:nx, jj ) + uu( 1:nx-2, jj) ) + ...
        2.0*(1.0 - epsilon)*uu( 2:nx-1, jj) - uu( 2:nx-1, jj-1);
%    for ii = 2:nx-1
%        uu( ii, jj+1) = epsilon*( uu( ii+1, jj) + uu( ii-1, jj))+...
%            2.0*(1.0 - epsilon)*uu( ii, jj) - uu(ii,jj-1);
%    end
end
